VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.ocx"
Begin VB.Form frmDPC_ExportRawMat 
   Caption         =   "#Export raw material B7"
   ClientHeight    =   6330
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   11370
   LinkTopic       =   "Form2"
   ScaleHeight     =   6330
   ScaleWidth      =   11370
   StartUpPosition =   3  'Windows Default
   Tag             =   "frmDPC_ExportRawMat"
   Visible         =   0   'False
   Begin MSComctlLib.TabStrip tbs_Main 
      Height          =   375
      Left            =   45
      TabIndex        =   1
      Tag             =   "tbs_Main"
      Top             =   555
      Width           =   11205
      _ExtentX        =   19764
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   2
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Coil"
            Key             =   "tab_Coil"
            Object.Tag             =   "tab_Coil"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Inlay"
            Key             =   "tab_Inlay"
            Object.Tag             =   "tab_Inlay"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmd_Cancel 
      Caption         =   "#Cancel"
      Height          =   555
      Left            =   9600
      TabIndex        =   23
      Tag             =   "cmd_Cancel"
      Top             =   5730
      Width           =   1680
   End
   Begin VB.CommandButton btn_Export 
      Caption         =   "#Export"
      Default         =   -1  'True
      Height          =   555
      Left            =   7755
      TabIndex        =   22
      Tag             =   "btn_Export"
      Top             =   5730
      Width           =   1680
   End
   Begin VB.TextBox txt_IdentNr 
      Height          =   360
      Left            =   1530
      TabIndex        =   0
      Top             =   120
      Width           =   2325
   End
   Begin VB.Frame fra_Coil 
      Caption         =   "#Coil"
      Height          =   1875
      Left            =   15
      TabIndex        =   2
      Tag             =   "fra_Coil"
      Top             =   3555
      Width           =   11205
      Begin VB.TextBox txt_CoilIdentNrTmp 
         Height          =   375
         Left            =   1560
         TabIndex        =   8
         Top             =   1335
         Width           =   2295
      End
      Begin VB.TextBox txt_CoilMatPrefix 
         Height          =   345
         Left            =   6045
         TabIndex        =   5
         Top             =   645
         Width           =   1965
      End
      Begin VB.TextBox txt_CoilMatType 
         Height          =   345
         Left            =   6045
         TabIndex        =   4
         Top             =   270
         Width           =   1965
      End
      Begin Project1.ArmCombobox cbo_CoilMaterial 
         Height          =   345
         Left            =   1575
         TabIndex        =   3
         Top             =   270
         Width           =   2820
         _ExtentX        =   4974
         _ExtentY        =   609
      End
      Begin VB.TextBox txt_CoilThickness 
         Height          =   375
         Left            =   6045
         TabIndex        =   7
         Top             =   1395
         Width           =   885
      End
      Begin VB.TextBox txt_CoilWidth 
         Height          =   375
         Left            =   6045
         TabIndex        =   6
         Top             =   1005
         Width           =   900
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Coil template"
         Height          =   255
         Index           =   10
         Left            =   105
         TabIndex        =   33
         Tag             =   "lbl_CoilTemplate"
         Top             =   1440
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Material prefix"
         Height          =   255
         Index           =   8
         Left            =   4500
         TabIndex        =   32
         Tag             =   "lbl_CoilMatPrefix"
         Top             =   705
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Material type"
         Height          =   255
         Index           =   7
         Left            =   4500
         TabIndex        =   31
         Tag             =   "lbl_CoilMattype"
         Top             =   330
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Material"
         Height          =   255
         Index           =   6
         Left            =   150
         TabIndex        =   30
         Tag             =   "lbl_CoilMaterial"
         Top             =   345
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Thickness"
         Height          =   255
         Index           =   3
         Left            =   4500
         TabIndex        =   26
         Tag             =   "lbl_CoilThickness"
         Top             =   1455
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Width"
         Height          =   255
         Index           =   2
         Left            =   4500
         TabIndex        =   25
         Tag             =   "lbl_CoilWidth"
         Top             =   1080
         Width           =   1335
      End
   End
   Begin VB.Frame fra_Inlay 
      Caption         =   "#Inlay"
      Height          =   2340
      Left            =   45
      TabIndex        =   9
      Tag             =   "fra_Inlay"
      Top             =   975
      Width           =   11190
      Begin VB.TextBox txt_InlayUoM2 
         Height          =   375
         Left            =   8325
         TabIndex        =   21
         Tag             =   "txt_InlayUoM2"
         Top             =   1890
         Width           =   720
      End
      Begin VB.TextBox txt_InlayPrice2 
         Height          =   375
         Left            =   6120
         TabIndex        =   20
         Tag             =   "txt_InlayPrice2"
         Top             =   1890
         Width           =   1140
      End
      Begin VB.TextBox txt_InlayUoM 
         Height          =   375
         Left            =   3975
         TabIndex        =   19
         Tag             =   "txt_InlayUoM"
         Top             =   1890
         Width           =   720
      End
      Begin VB.TextBox txt_InlayPrice 
         Height          =   375
         Left            =   1770
         TabIndex        =   18
         Tag             =   "txt_InlayPrice"
         Top             =   1890
         Width           =   1140
      End
      Begin VB.TextBox txt_InlayMaterial2 
         Height          =   375
         Left            =   6120
         TabIndex        =   17
         Tag             =   "txt_InlayDesc"
         Top             =   1485
         Width           =   4995
      End
      Begin VB.TextBox txt_InlayMaterial 
         Height          =   375
         Left            =   1770
         TabIndex        =   16
         Tag             =   "txt_InlayMaterial"
         Top             =   1485
         Width           =   3900
      End
      Begin VB.TextBox txt_InlayName2 
         Height          =   375
         Left            =   6120
         TabIndex        =   15
         Tag             =   "txt_InlayName2"
         Top             =   1080
         Width           =   4995
      End
      Begin VB.TextBox txt_InlayName 
         Height          =   375
         Left            =   1770
         TabIndex        =   14
         Tag             =   "txt_InlayName"
         Top             =   1080
         Width           =   3900
      End
      Begin VB.CommandButton btn_SelectInlay 
         Caption         =   "..."
         Height          =   360
         Left            =   5670
         TabIndex        =   11
         Tag             =   "btn_SelectInlay"
         Top             =   270
         Width           =   435
      End
      Begin VB.TextBox txt_InlayIdentNrTmp 
         Height          =   375
         Left            =   1770
         TabIndex        =   10
         Top             =   270
         Width           =   3900
      End
      Begin VB.TextBox txt_InlayLength 
         Height          =   375
         Left            =   1770
         TabIndex        =   12
         Top             =   675
         Width           =   1140
      End
      Begin VB.TextBox txt_InlayWidth 
         Height          =   375
         Left            =   4545
         TabIndex        =   13
         Top             =   675
         Width           =   1095
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#UoM"
         Height          =   255
         Index           =   14
         Left            =   7380
         TabIndex        =   38
         Tag             =   "lbl_InlayUoM2"
         Top             =   1935
         Width           =   660
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#UoM"
         Height          =   255
         Index           =   13
         Left            =   3030
         TabIndex        =   37
         Tag             =   "lbl_InlayUoM"
         Top             =   1935
         Width           =   660
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Inlay price"
         Height          =   255
         Index           =   12
         Left            =   150
         TabIndex        =   36
         Tag             =   "lbl_InlayPrice"
         Top             =   1995
         Width           =   1545
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Inlay material"
         Height          =   255
         Index           =   11
         Left            =   150
         TabIndex        =   35
         Tag             =   "lbl_InlayMaterial"
         Top             =   1590
         Width           =   1545
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Inlay name"
         Height          =   255
         Index           =   9
         Left            =   150
         TabIndex        =   34
         Tag             =   "lbl_InlayName"
         Top             =   1185
         Width           =   1545
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Inlay template"
         Height          =   255
         Index           =   5
         Left            =   135
         TabIndex        =   29
         Tag             =   "lbl_InlayTemplate"
         Top             =   375
         Width           =   1545
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Length (mm)"
         Height          =   255
         Index           =   1
         Left            =   150
         TabIndex        =   28
         Tag             =   "lbl_InlayLength"
         Top             =   735
         Width           =   1545
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Width (mm)"
         Height          =   255
         Index           =   4
         Left            =   3135
         TabIndex        =   27
         Tag             =   "lbl_InlayWidth"
         Top             =   735
         Width           =   1335
      End
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#New IdentNr"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   24
      Tag             =   "lbl_NewIdentNr"
      Top             =   210
      Width           =   1335
   End
End
Attribute VB_Name = "frmDPC_ExportRawMat"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmDPC_ExportRawMat"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private me_PriceBookType As eDPCPriceBookType
Private ml_U_Code As Long
Private ms_Language_Code As String
Private mc_ScreenLabels As Long
Private mb_InternalInit As Boolean
Private ml_ActiveRow As Long
Private mo_Tools As DPC_Tools
Private mo_BOM As DPC_BOM

#If ENV = LIVE Then
Private mo_Sys As Object
Private mo_Db As Object
Private mo_DbBaeurer As Object
Private mo_FSO As Object
#Else
Private mo_Sys As ARMSYSCOMLib.ArmSYS
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_DbBaeurer As ARMSYSCOMLib.ArmDb
Private mo_FSO As Scripting.FileSystemObject
#End If

Private ms_BaeurerServer As String
Private ms_BaeurerDatabase As String
Private ms_BaeurerLoginName As String
Private ms_BaeurerPassword As String
Private ms_BaeurerSource As String
Private ml_BaeurerFi_Nr As Long

Public Result As Boolean
Public COF_Id As String
Public OFD_Id As String
Public ResetQty As Boolean
Public IsAlt As Boolean
Public AltParent As String
Public AltParentName As String

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler
    
Dim ls_req As String
Dim ls_Connect() As String
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
#If ENV = LIVE Then
  Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
  Set mo_DbBaeurer = CreateObject("ArmSYSCOM.ArmDb")
#Else
  Set mo_Sys = New ARMSYSCOMLib.ArmSYS
  Set mo_DbBaeurer = New ARMSYSCOMLib.ArmDb
#End If

  Set mo_BOM = New DPC_BOM
  Set mo_BOM.Tools = mo_Tools
  
  Result = False
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  ls_Connect = Split(mo_Tools.GetAConfigData("DPC_BaeurerConnection"), SEP)
  If UBound(ls_Connect) = 5 Then
    ms_BaeurerServer = ls_Connect(0)
    ms_BaeurerDatabase = ls_Connect(1)
    ms_BaeurerLoginName = ls_Connect(2)
    ms_BaeurerPassword = ls_Connect(3)
    ms_BaeurerSource = ls_Connect(4)
    ml_BaeurerFi_Nr = Val(ls_Connect(5))
  Else
      Err.Raise ArmErr.PropertyNotSet, "Split(mo_Tools.GetAConfigData(""DPC_BaeurerConnection"")", "Missing or invalid configuration"
  End If
  
  ls_req = "SELECT MAT.MAT_Id,MAT_Name, MAT.MAT_Prefx, MAT.MAT_Werk "
  ls_req = ls_req & "FROM DPC_Material MAT "
  ls_req = ls_req & "INNER JOIN DPC_MaterialDesc MATD on (MAT.MAT_Id=MATD.MAT_Id AND MATD.Language_Code='E') "
  ls_req = ls_req & "WHERE MAT.Drop_Flag=''"
  cbo_CoilMaterial.Request = ls_req
  
  Call mo_Tools.EnableControl(txt_IdentNr, False)
  Call mo_Tools.EnableControl(txt_InlayIdentNrTmp, True)
  Call mo_Tools.EnableControl(txt_CoilIdentNrTmp, False)
  
  
  Call mo_Tools.EnableControl(txt_InlayIdentNrTmp, False)
  Call mo_Tools.EnableControl(txt_InlayName, False)
  Call mo_Tools.EnableControl(txt_InlayMaterial, False)
  Call mo_Tools.EnableControl(txt_InlayPrice, False)
  Call mo_Tools.EnableControl(txt_InlayUoM, False)
  
  Call fra_Inlay.Move(0, tbs_Main.Top + tbs_Main.Height, Width, btn_Export.Top - (tbs_Main.Top + tbs_Main.Height) - 200)
  Call fra_Coil.Move(0, tbs_Main.Top + tbs_Main.Height, Width, btn_Export.Top - (tbs_Main.Top + tbs_Main.Height) - 200)
  Call tbs_Main_Click
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Set mo_BOM = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Private Sub btn_Export_Click()
On Error GoTo ErrHandler

Dim lo_XmlExport As New DPC_Interface
Dim lo_Generate As New DPC_Generate
Dim ld_Width As Double, ld_Length As Double, ld_Thickness As Double, ld_Price As Double
Dim ls_IdentNrTmp As String

  Call mo_Tools.LockScreen(Me, True)
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
    Call mo_Tools.LockScreen(Me, False)
    Exit Sub
  End If
  txt_IdentNr.Text = ""
  lo_Generate.CT_Code = ""
  lo_Generate.CURR_Code = ""
  lo_Generate.ValidityDate = Date
  lo_Generate.Language_Code = ms_Language_Code
  lo_Generate.U_Code = ml_U_Code
  Set lo_Generate.ArmDb = mo_Db
  Set lo_Generate.Tools = mo_Tools
  Call lo_Generate.Load_A_COM
  
  
  Set lo_XmlExport.ArmDb = mo_Db
  Set lo_XmlExport.Tools = mo_Tools
  Call lo_XmlExport.Load_A_COM
  
  
  
  If tbs_Main.SelectedItem.Index = 1 Then
  
    If txt_CoilMatType.Text = "" Then
      Call MsgBox("Please enter material type")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If txt_CoilMatPrefix.Text = "" Then
      Call MsgBox("Please enter material prefix")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    ld_Width = mo_Tools.ScreenToDbl(txt_CoilWidth.Text)
    ld_Thickness = mo_Tools.ScreenToDbl(txt_CoilThickness.Text)
    
    If ld_Width = 0 Then
      Call MsgBox("Please enter coil width")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If ld_Thickness = 0 Then
      Call MsgBox("Please enter coil thickness")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    txt_CoilIdentNrTmp.Text = lo_Generate.GetCoilTemplateIdentNr(txt_CoilMatPrefix.Text, txt_CoilMatType.Text, ld_Thickness)
    If Not mo_BOM.LoadBOMFromBaeurer(mo_Db, mo_DbBaeurer, ms_Language_Code, txt_CoilIdentNrTmp.Text) Then
      Call MsgBox("Cannot load material: " & txt_CoilIdentNrTmp.Text)
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If Not mo_BOM.LoadBOMPriceFromBaeurer(mo_DbBaeurer, txt_CoilIdentNrTmp.Text, 1) Then
      Call MsgBox("Cannot load material price: " & txt_CoilIdentNrTmp.Text)
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    mo_BOM.BOM_CutWidth = ld_Width
    mo_BOM.BOM_IdentNrTmp = mo_BOM.BOM_IdentNr
    mo_BOM.BOM_IdentNr = DPC_BOM_NEW_IDENTNR
    
    If lo_XmlExport.Bae_ExportCoil(mo_BOM) Then
        Call MsgBox("Material was exported successfuly, IdentNr = " & mo_BOM.BOM_IdentNr)
    Else
        Call MsgBox("Material export failed")
    End If
  Else
    ld_Length = mo_Tools.ScreenToDbl(txt_InlayLength.Text)
    ld_Width = mo_Tools.ScreenToDbl(txt_InlayWidth.Text)
    ld_Price = mo_Tools.ScreenToDbl(txt_InlayPrice2.Text)
    
    If (ld_Length = 0) Or (ld_Width = 0) Then
      Call MsgBox("Please enter inlay size")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If txt_InlayIdentNrTmp.Text = "" Then
      Call MsgBox("Please enter inlay template IdentNr")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
  
    If txt_InlayName2.Text = "" Then
      Call MsgBox("Please enter inlay name")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
  
    If (StrComp(txt_InlayUoM2.Text, DPC_UOM_M2, vbTextCompare) <> 0) And (StrComp(txt_InlayUoM2.Text, DPC_UOM_PCS, vbTextCompare) <> 0) Then
      Call MsgBox("Please enter inlay UoM")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If (ld_Price = 0) Then
      Call MsgBox("Please enter inlay price")
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    If Not mo_BOM.LoadBOMFromBaeurer(mo_Db, mo_DbBaeurer, ms_Language_Code, txt_InlayIdentNrTmp.Text) Then
      Call MsgBox("Cannot load material: " & txt_InlayIdentNrTmp.Text)
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    
    mo_BOM.BOM_CutWidth = ld_Width
    mo_BOM.BOM_CutLength = ld_Length
    mo_BOM.UM_Code = txt_InlayUoM2.Text
    mo_BOM.BOM_Cost = ld_Price
    mo_BOM.BOM_IdentNrTmp = mo_BOM.BOM_IdentNr
    mo_BOM.BOM_IdentNr = DPC_BOM_NEW_IDENTNR
    mo_BOM.BOM_Name = txt_InlayName2.Text
    mo_BOM.BOM_Material = txt_InlayMaterial2.Text
    
    'mo_BOM.BOM_Name = "Akustikvlieszuschnitt " & mo_Tools.DblToScreen(ao_BOM.BOM_CutLength, 1) & "x" & mo_Tools.DblToScreen(ao_BOM.BOM_CutWidth, 1) & " mm"
    If lo_XmlExport.Bae_ExportInlay(mo_BOM) Then
        Call MsgBox("Material was exported successfuly, IdentNr = " & mo_BOM.BOM_IdentNr)
    Else
        Call MsgBox("Material export failed")
    End If
  End If
  Call lo_Generate.Unload_A_COM
  Set lo_Generate = Nothing
  
  Call lo_XmlExport.Unload_A_COM
  Set lo_XmlExport = Nothing
  
  txt_IdentNr.Text = mo_BOM.BOM_IdentNr
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Export_Click")
End Sub

Private Function SelectRawMaterial(ByVal ae_Categ As eDPCBOMMaterial, ByVal ab_EnableFilter As Boolean) As DPC_BOM
On Error GoTo ErrHandler

Dim lo_frmDPC_BOM As frmDPC_BOM
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Call MsgBox("Cannot connect to Baeurer server")
    Exit Function
  End If
  Set SelectRawMaterial = Nothing
  Set lo_frmDPC_BOM = New frmDPC_BOM
  Load lo_frmDPC_BOM
  Set lo_frmDPC_BOM.Tools = mo_Tools
  Set lo_frmDPC_BOM.ArmDb = mo_Db
  Set lo_frmDPC_BOM.ArmDbBaeurer = mo_DbBaeurer
  lo_frmDPC_BOM.Language_Code = ms_Language_Code
  lo_frmDPC_BOM.Categ = ae_Categ
  lo_frmDPC_BOM.FilterEnabled = ab_EnableFilter
  Call lo_frmDPC_BOM.Load_A_COM
  
  Call mo_Tools.LockScreen(Me, False)
  Call mo_Tools.ShowModalForm(lo_frmDPC_BOM)
  Call mo_Tools.LockScreen(Me, True)
  If lo_frmDPC_BOM.Result Then
    Call mo_BOM.LoadBOMFromBaeurer(mo_Db, mo_DbBaeurer, ms_Language_Code, lo_frmDPC_BOM.IdentNr)
    Call mo_BOM.LoadBOMPriceFromBaeurer(mo_DbBaeurer, lo_frmDPC_BOM.IdentNr, 1)
    Set SelectRawMaterial = mo_BOM
  End If
  Call lo_frmDPC_BOM.Unload_A_COM
  Unload lo_frmDPC_BOM
  Set lo_frmDPC_BOM = Nothing
  Exit Function
ErrHandler:
  Call ErrorHandler("SelectRawMaterial")
End Function

Private Sub InitInlayData(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

  txt_InlayIdentNrTmp.Text = ao_BOM.BOM_IdentNr
  txt_IdentNr.Text = DPC_BOM_NEW_IDENTNR
  txt_InlayName.Text = ao_BOM.BOM_Name
  ao_BOM.BOM_CutWidth = mo_Tools.ScreenToDbl(txt_InlayWidth.Text)
  ao_BOM.BOM_CutLength = mo_Tools.ScreenToDbl(txt_InlayLength.Text)
  txt_InlayMaterial.Text = ao_BOM.BOM_Material
  txt_InlayMaterial2.Text = ao_BOM.BOM_Material
  txt_InlayPrice.Text = mo_Tools.DblToScreen(ao_BOM.BOM_Cost)
  txt_InlayUoM.Text = ao_BOM.UM_Code
  txt_InlayUoM2.Text = DPC_UOM_PCS
  Call InitInlayName(ao_BOM)
  Call InitInlayPrice(ao_BOM)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitInlayData")
End Sub

Private Sub InitInlayName(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler
  
  txt_InlayName2.Text = ao_BOM.CreateInlayName(mo_Db, ao_BOM.BOM_Name)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitInlayName")
End Sub

Private Sub InitInlayPrice(ByVal ao_BOM As DPC_BOM)
On Error GoTo ErrHandler

  If StrComp(ao_BOM.UM_Code, DPC_UOM_PCS, vbTextCompare) = 0 Then
    txt_InlayPrice2.Text = mo_Tools.DblToScreen(ao_BOM.BOM_Cost)
  ElseIf StrComp(ao_BOM.UM_Code, DPC_UOM_M2, vbTextCompare) = 0 Then
    txt_InlayPrice2.Text = mo_Tools.DblToScreen(mo_Tools.FromPriceM2toPCS(ao_BOM.BOM_Cost, (ao_BOM.BOM_CutLength * ao_BOM.BOM_CutWidth) / 1000000))
  Else
    txt_InlayPrice2.Text = mo_Tools.DblToScreen(0)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitInlayPrice")
End Sub

Private Sub btn_SelectInlay_Click()
On Error GoTo ErrHandler

Dim lo_BOM As DPC_BOM

  Call mo_Tools.LockScreen(Me, True)
  If mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Set lo_BOM = SelectRawMaterial(eDPCBOMMaterial.bcInlay, False)
    If Not lo_BOM Is Nothing Then
      Call InitInlayData(lo_BOM)
      tbs_Main.Enabled = False
    End If
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Inlay_Click")
End Sub

Private Sub txt_InlayLength_Validate(Cancel As Boolean)
On Error GoTo ErrHandler

  mo_BOM.BOM_CutLength = mo_Tools.ScreenToDbl(txt_InlayLength.Text)
  Call InitInlayName(mo_BOM)
  Call InitInlayPrice(mo_BOM)
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_InlayLength_Validate")
End Sub

Private Sub txt_InlayWidth_Validate(Cancel As Boolean)
On Error GoTo ErrHandler

  mo_BOM.BOM_CutWidth = mo_Tools.ScreenToDbl(txt_InlayWidth.Text)
  Call InitInlayName(mo_BOM)
  Call InitInlayPrice(mo_BOM)
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_InlayLength_Validate")
End Sub

Private Sub cbo_CoilMaterial_ComboItemSelected()
On Error GoTo ErrHandler

  txt_CoilMatPrefix.Text = cbo_CoilMaterial.SelectedItem.GetData(2)
  txt_CoilMatType.Text = cbo_CoilMaterial.SelectedItem.GetData(3)
  txt_IdentNr.Text = DPC_BOM_NEW_IDENTNR
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_CoilMaterial_ComboItemSelected")
End Sub

Private Sub cmd_Cancel_Click()
On Error GoTo ErrHandler

  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("cmd_Cancel_Click")
End Sub

Private Sub tbs_Main_Click()
On Error GoTo ErrHandler

  fra_Coil.Visible = tbs_Main.SelectedItem.Index = 1
  fra_Inlay.Visible = tbs_Main.SelectedItem.Index = 2
  Exit Sub
ErrHandler:
  Call ErrorMessage("tbs_Main_Click")
End Sub

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

